<?php
session_start();
require_once('../db.php');
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Mike Coustic - Gitarrist</title>
<meta name="description" content="Veranstaltungstermine von Mike Coustic. Zusätzlich Hörbeispiele.">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://code.jquery.com/mobile/1.4.5/jquery.mobile-1.4.5.min.css">
<script src="https://code.jquery.com/jquery-1.11.1.min.js"></script>
<script src="https://code.jquery.com/mobile/1.4.5/jquery.mobile-1.4.5.min.js"></script>
<!-- eigene CSS-Anweisungen -->
<link href="design.css" rel="stylesheet">
</head>
<body>
<!-- Hier kommt die bearbeiten-Seite -->
<div data-role="page" id="bearbeiten" data-theme="b">
  <?php anzeige_kopfbereich('termine', false); ?>
  <div data-role="main" class="ui-content">
    <?php
    if ( isset($_SESSION['eingeloggt']) )
    {
      if ( isset($_REQUEST['id']) and $_REQUEST['id'] > 0 )
      {
        // laden der Daten
        $id = (INT) $_REQUEST['id'];
        $sql = "SELECT * FROM termine WHERE id = '$id' ";
        if ($erg = $db->query($sql)) {
          $datensatz = $erg->fetch_object();
        }        
        echo "<h1>Daten ändern</h1>";
      }
      if ( isset($_POST['datum']) and $_POST['datum'] != '' )
      {
          $datum     = $_POST['datum'];
          $beginn    = $_POST['beginn'];
          $ort       = $_POST['ort'];
          $anmerkung = $_POST['anmerkung'];
          // Überprüfen, ob neuer Datensatz oder Update eines bestehenden
          if ( ! isset( $_POST['id'] )) {
            // neuer Datensatz
            echo "<p>Datum: $datum";
            echo "<p>Beginn: $beginn";
            echo "<p>Ort: $ort";
            echo "<p>anmerkung: $anmerkung";
            $einfuegen = $db->prepare("INSERT INTO termine
                (datum, beginn, ort, anmerkung)
                VALUES (?, ?, ?, ?)");
            $einfuegen->bind_param('ssss', $datum, $beginn, $ort, $anmerkung);
            if ($einfuegen->execute()) {
                echo "<p>Daten werden gespeichert</p>";    
            }
          }
          else
          {
            $updaten = $db->prepare("UPDATE termine SET 
                datum=?,
                beginn=?,
                ort=?,
                anmerkung=?
                WHERE id=?" );
            $updaten->bind_param('ssssi', $datum, $beginn, $ort, $anmerkung, $id);
            if ($updaten->execute()) {
              echo "<p>Daten $id wurden geupdatet - betroffen war davon ";    
            }
            echo $updaten->affected_rows;
            echo " Datensatz</p>";
          }
      }
      else
      {
?>
    <form id="terminaufnehmen" method="post" action="bearbeiten.php">
        <div data-role="fieldcontain">
            <fieldset>
                <input type="hidden" name="id" id="id"
                <?php  
                if ( isset($datensatz->id) )
                {
                   echo 'value="'.$datensatz->id .'"'; 
                }
                ?>
                >
                <label for="datum">Datum</label>
                <input type="date" name="datum" id="datum"  
                <?php  
                if ( isset($datensatz->datum) )
                {
                    echo 'value="'. $datensatz->datum .'"'; 
                }
                ?>
                >
                <label for="beginn">Beginn</label>
                <input type="time" name="beginn" id="beginn"
                <?php  
                if ( isset($datensatz->beginn) )
                {
                  echo 'value="'. $datensatz->beginn .'"';
                }
                ?>                  
                >
                <label for="ort">Ort</label>
                <input type="text" name="ort" id="ort"
                <?php  
                if ( isset($datensatz->ort) )
                { 
                  echo 'value="'. $datensatz->ort .'"';
                }
                ?>                  
                >
                <label for="anmerkung">Anmerkung</label>
                <input type="text" name="anmerkung" id="anmerkung"
                <?php  
                if ( isset($datensatz->anmerkung) )
                {
                    echo 'value="'. $datensatz->anmerkung .'"';
                }
                ?>                    
                >
                <input type="submit" value="speichern">
            </fieldset>
        </div>
    </form>   
<?php
        }
    }
    else
    {
      echo "<h1>Bitte einloggen</h1>";
    }
    ?>
  </div>
  <?php anzeige_fussbereich('', false); ?>
</div>
</body>
</html>