<?php
session_start();
require_once('../db.php');

if ( isset($_GET['aktion']) and $_GET['aktion'] == "ausloggen") 
{
	unset($_SESSION['eingeloggt']);
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Mike Coustic - Gitarrist</title>
<meta name="description" content="Veranstaltungstermine von Mike Coustic.
 Zusätzlich Hörbeispiele.">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://code.jquery.com/mobile/1.4.5/jquery.mobile-1.4.5.min.css"
 rel="stylesheet">
<script src="https://code.jquery.com/jquery-1.11.1.min.js"></script>
<script src="https://code.jquery.com/mobile/1.4.5/jquery.mobile-1.4.5.min.js"></script>
<!-- eigene CSS-Anweisungen -->
<link href="design.css" rel="stylesheet">
</head>
<body>

<div data-role="page" id="startseite" data-theme="b">
<!-- Hier kommt die Startseite -->
  <?php anzeige_kopfbereich('startseite'); ?>

  <div data-role="main" class="ui-content">
    <h1>Mike Coustic - Gitarrist</h1>

    <p>Ich freue mich, dass du den Weg zu mir gefunden hast.</p>

    <p>Damit du den Weg zu meinen Veranstaltungen findest, hier die <a href="#termine">aktuellen Veranstaltungstermine</a>.</p>

    <img src="bilder/musiker.jpg" class="bildiminhalt" alt="Mike Coustic">

    <p>Viel Spaß auf der Seite</p>

    <p>Mike Coustic</p>    
  </div>

  <?php anzeige_fussbereich(); ?>
</div>

<!-- Hier kommt die Terminseite -->
<?php
$sql = "SELECT * FROM termine WHERE datum >= '". date("Y-m-d") ."' ORDER BY datum";
if ($erg = $db->query($sql)) {
    while ($datensatz = $erg->fetch_object()) {
        $daten[] = $datensatz;
    }
}
?>

<div data-role="page" id="termine" data-theme="b">
  <?php anzeige_kopfbereich('termine'); ?>
  <div data-role="main" class="ui-content">
    <h1>Termine</h1>

    <table id="meineTabelle" data-role="table" class="ui-responsive" data-mode="columntoggle" data-column-btn-text="Spalten" >
      <thead>
        <tr>
          <th data-priority="4">ID</th>
          <th>Datum</th>
          <th data-priority="1">Beginn</th>
          <th data-priority="2">Veranstaltungsort</th>
          <th data-priority="3">Anmerkung</th>

        </tr>
      </thead>
      <tbody>

    <?php
    foreach ($daten as $inhalt) {
    ?>
        <tr>
            <td class="tabellentext">
                <?php echo $inhalt->id; ?>
            </td>
            <td>
                <?php 
                // echo $inhalt->datum;
                echo '<a data-ajax="false" data-role="button" href="details.php?id=';
                echo $inhalt->id;
                echo '">';
                echo date("d.m.Y", strtotime($inhalt->datum)); 
                echo '</a>';                
                ?>

            </td>
            <td class="tabellentext">
                <?php echo $inhalt->beginn; ?>
            </td>
            <td class="tabellentext">
                <?php echo $inhalt->ort; ?>
            </td>
            <td class="tabellentext">
                <?php echo $inhalt->anmerkung; ?>
            </td>           
      </tr>
    <?php
    }
    ?>

      </tbody>
    </table>

    <?php
    if ( isset($_SESSION['eingeloggt']) )
    {
      echo '<div id="buttons_details">';
      echo '<a data-ajax="false" href="bearbeiten.php" style="background-color: black; " class="ui-btn ui-icon-plus ui-btn-inline ui-btn-icon-left">neuer Termin</a>';
      echo '</div>';
    }    
    ?>    

  </div>
  <?php anzeige_fussbereich(); ?>
</div>

<!-- Hier kommt die Musik-Teaser-Seite -->
<div data-role="page" id="musik" data-theme="b">
  <?php anzeige_kopfbereich(); ?>
  <div data-role="main" class="ui-content">
    <h1>Reinhören - 30 Sekunden Beispiel</h1>
    <p>Aus dem Album "Memories":</p> 
	<audio controls autoplay>
	          <source src="mp3/musikausschnitt-mike-coustic-memories.mp3"
	  type="audio/mpeg">
	  Sorry - Ihre Browser hat keine Unterstützung für dieses Audio-Format.
	</audio>

  </div>
  <?php anzeige_fussbereich('musik'); ?>
</div>

<!-- Hier kommt die Kontakt-Seite -->
<div data-role="page" id="kontakt" data-theme="b">
  <?php anzeige_kopfbereich(); ?>

  <div data-role="main" class="ui-content">
    <h1>Kontakt</h1>
    <p>Mike Coustic</p>
	<p>Telefon <a href="tel:00490123555456789000">(0049) 0123 555 456 789 000</a></p>
	<p>Mail: <a href="mailto:kontakt@example.com">kontakt@example.com</a> </p>
  </div>

  <?php anzeige_fussbereich('kontakt'); ?>
</div>

<!-- Hier kommt die Login-Seite -->
<div data-role="page" id="login" data-theme="b">
 <?php anzeige_kopfbereich('', false); ?>
 <div data-role="main" class="ui-content">
   <h1>Login</h1>
   <?php
   if ( isset($_POST['benutzername']) 
        and isset($_POST['kennwort'])
        and $_POST['benutzername'] == 'admin'
        and $_POST['kennwort'] == '1234'
      )
   {
      $_SESSION['eingeloggt'] = date("H:i:s");
   }

   if ( isset($_SESSION['eingeloggt']) )
   {
      // eingeloggt, daher Möglichkeit zum Ausloggen geben
      echo '<p><a data-ajax="false" href="index.php?aktion=ausloggen">ausloggen</a>
            </p>';
   }
   else
   {
   ?>
   <form data-ajax="false" id="loginformular" method="post" action="index.php#login">
        <div data-role="fieldcontain">
            <fieldset>
                <label for="benutzername">Benutzername</label>
                <input type="text" name="benutzername" id="benutzername" autofocus>
                <label for="kennwort">Kennwort</label>
                <input type="password" name="kennwort" id="kennwort">
                <input type="submit" value="einloggen">
            </fieldset>
        </div>
   </form>
   <?php
   }
   ?>
 </div>
 <?php anzeige_fussbereich('login', false); ?>
</div>

</body>
</html>